#!/bin/sh
EX=$1
PLATFORM=$2

if [ "$LIMAN_ROOT" = "" ]; then
	echo Error: LIMAN_ROOT environment variable is not defined
	echo
	exit 1
fi

if [ "$EX" = "" ]; then
	echo
	echo usage: jtest.sh testapp [platform] [product] [license_file]
	echo example: jtest.sh testapp [osx64x86]
	echo
	exit 1
fi


if [ "$PLATFORM" = "" ]; then
	source $LIMAN_ROOT/lib/platform.sh
fi	


MINIVER="$($JAVA_HOME/bin/java -version 2>&1 | awk '/version/ {print $3}' | awk -F\" '{ print $2}' | awk -F . '{print $1"_"$2}')"


JARFILE=liman$MINIVER.jar
JARG=
JOPT="-Djava.library.path=$LIMAN_ROOT/lib/$PLATFORM"
JCLASSP="-classpath $LIMAN_ROOT/lib/$JARFILE:./"
echo $JAVA_HOME
echo $JARFILE
echo $JCLASSP

$JAVA_HOME/bin/javac ${JCLASSP} ./$EX.java 

echo Running $EX
if [ "$EX" = "ex2" ]; then
	PRODUCT=TESTAPP
	APPKEYS=$LIMAN_ROOT/apps/keys/$PRODUCT
	LICFILE=usr_453A0BD1BC6C5D50
	JARG="$APPKEYS/$LICFILE.lic $APPKEYS/$PRODUCT_public.key $APPKEYS/$PRODUCT_private.key"
elif [ "$3" = "" ]; then
	PRODUCT=TESTAPP
	APPKEYS=$LIMAN_ROOT/apps/keys/$PRODUCT
	LICFILE=$3
	if [ "$LICFILE" = "" ]; then
		LICFILE=usr_453A0BD1BC6C5D50
	fi
	JARG="$PRODUCT $APPKEYS/$LICFILE.lic"
else
	PRODUCT=$3
	LICFILE=$4
	if [ "$LICFILE" = "" ]; then
		echo usage: jtest.sh testapp PRODUCT LICENSE
		exit 1
	fi
	APPKEYS=$LIMAN_ROOT/apps/keys/$PRODUCT
	JARG="$PRODUCT $APPKEYS/$LICFILE.lic"
fi

$JAVA_HOME/bin/java ${JCLASSP} ${JOPT} $EX ${JARG}

