@echo off&setlocal
rem cmd
rem Generate a new license for LIMAN SDK using its designated key-pair
rem (c) Baroks Inc.
rem $Id$
rem
set LIMAN_ROOT=..\..

rem get PLATFORM from directory
for %%a in (.) do set PLATFORM=%%~na
@echo %PLATFORM%

set PRODUCT=%1
if "%PRODUCT%" == "" goto usage
shift 1
set LIMGEN=%LIMAN_ROOT%\lib\%PLATFORM%\limgen

rem Location of public key
set PUB=%LIMAN_ROOT%\lib\%PLATFORM%\%PRODUCT%\lib_public.key

rem Location of private key
set PRIV=%LIMAN_ROOT%\lib\%PLATFORM%\%PRODUCT%\lib_private.key

rem Generate a product key with specified input
rem Type limgen -h for help
@echo Product: %PRODUCT%
@echo Private key file: %PUB%
@echo Public key file: %PRIV%
@echo %LIMGEN% --product=%PRODUCT% --privkeyfile=%PRIV%  --pubkeyfile=%PUB% --major=1 --minor=3 --features=15,3,3,5  %1 %2 %3 %4 %5 %6 %7 %8 %9
%LIMGEN% --product=%PRODUCT% --privkeyfile=%PRIV%  --pubkeyfile=%PUB% --major=1 --minor=3 --features=15,3,3,5 %1 %2 %3 %4 %5 %6 %7 %8 %9
goto end

:usage
@echo Usage: lg_library [limgen-options]
goto end
:noplatform
echo Variable 'PLATFORM' not set. Type 'set PLATFORM=<platform>' and re-run
goto end
:end