----------------------------------------------------------------------------
-- Lua code generated with wxFormBuilder (version Dec  8 2017)
-- http://www.wxformbuilder.org/
----------------------------------------------------------------------------

-- Load the wxLua module, does nothing if running from wxLua, wxLuaFreeze, or wxLuaEdit
package.cpath = package.cpath..";./?.dll;./?.so;../lib/?.so;../lib/vc_dll/?.dll;../lib/bcc_dll/?.dll;../lib/mingw_dll/?.dll;"
package.cpath = package.cpath .. os.getenv("LIMAN_ROOT") .. "/bin/win32x86/?.dll"
require("wx")
local liman = require 'lualiman'
local defaults = require 'liman_defaults'

UI = {}

---
-- C-sprintf
sprintf = function(fmt, ...)   
    local s=string.format(fmt, ...)
    return s 
end
---
-- C-printf
printf = function(fmt, ...) 
    io.stdout:flush() 
    io.write(string.format(fmt, ...)) 
    io.stdout:flush() 
end 

string.splitz = function(str, delim)
  local delim = delim or "%s"
  local pattern = pattern or "[^" .. delim .. "]+"
  if pattern:len() == 0 then pattern = "[^" .. delim .. "]+" end
  local parts = {__index = table.insert}
  setmetatable(parts, parts)
  str:gsub(pattern, parts)
  setmetatable(parts, nil)
  parts.__index = nil
  return parts
end


---
-- Check error 
function checkerr(pEnv,nErr,isExit)
	local isExit = isExit or 0
	if nErr>0 then
		local errmsg = sprintf("Error %d: %s\n",nErr,liman.lim_errmsg(pEnv,nErr))
    wx.wxMessageBox(errmsg,
                   "Error",
                   wx.wxOK + wx.wxICON_INFORMATION,                   
                   UI.MyFrame1)
  end
end

-- create MyFrame1
function createControls()
  UI.MyFrame1 = wx.wxFrame (wx.NULL, wx.wxID_ANY, UI.limversion, wx.wxDefaultPosition, wx.wxSize( 500,300 ), wx.wxDEFAULT_FRAME_STYLE+wx.wxTAB_TRAVERSAL )
	UI.MyFrame1:SetSizeHints( wx.wxDefaultSize, wx.wxDefaultSize )
	
	UI.bSizer1 = wx.wxBoxSizer( wx.wxVERTICAL )
	
	UI.m_panel1 = wx.wxPanel( UI.MyFrame1, wx.wxID_ANY, wx.wxDefaultPosition, wx.wxDefaultSize, wx.wxTAB_TRAVERSAL )
	UI.bSizer2 = wx.wxBoxSizer( wx.wxVERTICAL )
	
	UI.fgSizer1 = wx.wxFlexGridSizer( 0, 2, 0, 0 )
	UI.fgSizer1:SetFlexibleDirection( wx.wxBOTH )
	UI.fgSizer1:SetNonFlexibleGrowMode( wx.wxFLEX_GROWMODE_SPECIFIED )
	
	UI.m_staticText1 = wx.wxStaticText( UI.m_panel1, wx.wxID_ANY, "Product", wx.wxDefaultPosition, wx.wxDefaultSize, 0 )
	UI.m_staticText1:Wrap( -1 )
	UI.fgSizer1:Add( UI.m_staticText1, 0, wx.wxALL, 5 )
	
	UI.m_textProd = wx.wxTextCtrl( UI.m_panel1, wx.wxID_ANY, "MYLUAPP", wx.wxDefaultPosition, wx.wxDefaultSize, 0 )
	UI.fgSizer1:Add( UI.m_textProd, 0, wx.wxALL, 5 )
	
	UI.m_staticText2 = wx.wxStaticText( UI.m_panel1, wx.wxID_ANY, "KeySize", wx.wxDefaultPosition, wx.wxDefaultSize, 0 )
	UI.m_staticText2:Wrap( -1 )
	UI.fgSizer1:Add( UI.m_staticText2, 0, wx.wxALL, 5 )
	
	UI.m_textKeySize = wx.wxTextCtrl( UI.m_panel1, wx.wxID_ANY, tostring(defaults.DEFAULT_KEYSIZE), wx.wxDefaultPosition, wx.wxDefaultSize, 0 )
	UI.fgSizer1:Add( UI.m_textKeySize, 0, wx.wxALL, 5 )
	
	UI.m_staticText3 = wx.wxStaticText( UI.m_panel1, wx.wxID_ANY, "HashSize", wx.wxDefaultPosition, wx.wxDefaultSize, 0 )
	UI.m_staticText3:Wrap( -1 )
	UI.fgSizer1:Add( UI.m_staticText3, 0, wx.wxALL, 5 )
	
	UI.m_textHashSize = wx.wxTextCtrl( UI.m_panel1, wx.wxID_ANY, tostring(defaults.DEFAULT_HASHSIZE), wx.wxDefaultPosition, wx.wxDefaultSize, 0 )
	UI.fgSizer1:Add( UI.m_textHashSize, 0, wx.wxALL, 5 )
	
	UI.m_staticText4 = wx.wxStaticText( UI.m_panel1, wx.wxID_ANY, "Seed", wx.wxDefaultPosition, wx.wxDefaultSize, 0 )
	UI.m_staticText4:Wrap( -1 )
	UI.fgSizer1:Add( UI.m_staticText4, 0, wx.wxALL, 5 )
	
	UI.m_textSeed = wx.wxTextCtrl( UI.m_panel1, wx.wxID_ANY, "1031", wx.wxDefaultPosition, wx.wxDefaultSize, 0 )
	UI.fgSizer1:Add( UI.m_textSeed, 0, wx.wxALL, 5 )
	
	
	UI.bSizer2:Add( UI.fgSizer1, 1, wx.wxEXPAND, 5 )
	
	UI.m_staticline1 = wx.wxStaticLine( UI.m_panel1, wx.wxID_ANY, wx.wxDefaultPosition, wx.wxDefaultSize, wx.wxLI_HORIZONTAL )
	UI.bSizer2:Add( UI.m_staticline1, 0, wx.wxEXPAND  + wx. wxALL, 5 )
	
	UI.bSizer3 = wx.wxBoxSizer( wx.wxHORIZONTAL )
	
	UI.m_button1 = wx.wxButton( UI.m_panel1, wx.wxID_ANY, "Generate KeyPair", wx.wxDefaultPosition, wx.wxDefaultSize, 0 )
	UI.bSizer3:Add( UI.m_button1, 0, wx.wxALL, 5 )
	
	UI.m_button2 = wx.wxButton( UI.m_panel1, wx.wxID_ANY, "Exit", wx.wxDefaultPosition, wx.wxDefaultSize, 0 )
	UI.bSizer3:Add( UI.m_button2, 0, wx.wxALL, 5 )
	
	
	UI.bSizer2:Add( UI.bSizer3, 0, wx.wxALIGN_RIGHT, 5 )
	
	
	UI.m_panel1:SetSizer( UI.bSizer2 )
	UI.m_panel1:Layout()
	UI.bSizer2:Fit( UI.m_panel1 )
	UI.bSizer1:Add( UI.m_panel1, 1, wx.wxEXPAND  + wx. wxALL, 5 )
	
	
	UI.MyFrame1:SetSizer( UI.bSizer1 )
	UI.MyFrame1:Layout()
	
	UI.MyFrame1:Centre( wx.wxBOTH )
  
	-- Connect Events
	
	UI.m_button1:Connect( wx.wxEVT_COMMAND_BUTTON_CLICKED, function(event)
	--implements OnGenerateClick
    UI.Product = tostring(UI.m_textProd:GetValue())
    UI.KeySize = tonumber(UI.m_textKeySize:GetValue())
    UI.HashSize = tonumber(UI.m_textHashSize:GetValue())
    UI.Seed = tonumber(UI.m_textSeed:GetValue())
    
    if string.len(UI.Product)>1 then
      nErr = liman.lim_gen_keypair(UI.KeySize,UI.Seed,UI.Product);
      checkerr(UI.pEnv,nErr,0)
      UI.szPublicKeyFile=sprintf("%s/%s_public.key",UI.Product,UI.Product)
      UI.szPrivateKeyFile=sprintf("%s/%s_private.key",UI.Product,UI.Product)     
    else
        wx.wxMessageBox('Product name is too short.\n' .. UI.limversion,
                           "Error",
                           wx.wxOK + wx.wxICON_INFORMATION,
                           UI.MyFrame1)      
    end
	end )
	
	UI.m_button2:Connect( wx.wxEVT_COMMAND_BUTTON_CLICKED, function(event)
	--implements OnExitClick
	  if UI.pEnv then
      nErr = liman.lim_delete_env(UI.pEnv)
    end
    UI.MyFrame1:Close(True)
	end )  
  
  UI.MyFrame1:Show(true) -- show the frame window
end

function main()
  local nErr = liman.lim_get_verkey(nil)  
  nErr,major,minor,build,rev,sbuf = liman.lim_get_verkey(nil)  
  UI.limversion = sprintf("LIMAN SDK %d.%d.%d %s",major,minor,rev,sbuf)
  createControls()
end

main()

wx.wxGetApp():MainLoop()
