/** 
 * @example testapp.cs
 *
 * @brief
 * This is a test application illustrating how to 
 * integrate LIMAN SDK to your software to protect 
 * it with license keys you generate with 'limgen'
 * or a derivative of it.
 *
 * It is also illustrated how license-features can
 * be used to let you impose license-based restrictions
 * on certain capabilities of your software. 
 */
using System;
using System.IO;
using System.Reflection;
using System.Text;
using LimanSDK.NET;

public class testapp
{

	private static String szLicFile;

	private static String szProduct;

    static testapp()
    {


    }
	
    //! [Sort Functions]

    public static int Quick_Sort(SWIGTYPE_p_LIMLIC pLic, int[] array)

    {

        if (0 == liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_0))
        {
			// feature is not available
			Console.WriteLine("Quick_Sort is not allowed with existing license");
            return liman.LIMERR_NOT_SUPPORTED;

        }

        /* INSERT the code to perform the sort */
		Console.WriteLine("Quick_Sort is allowed with existing license");

        return 0;

    }

    public static int Merge_Sort(SWIGTYPE_p_LIMLIC pLic, int[] array)

    {

        if (0 == liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_1))
        {
			// feature is not available
			Console.WriteLine("Merge_Sort is not allowed with existing license");
            return liman.LIMERR_NOT_SUPPORTED;

        }

        /* INSERT the code to perform the sort */
		Console.WriteLine("Merge_Sort is not allowed with existing license");

        return 0;

    }

    public static int Heap_Sort(SWIGTYPE_p_LIMLIC pLic, int[] array)

    {

        if (0 == liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_2))
        {
			// feature is not available
			Console.WriteLine("Heap_Sort is not allowed with existing license");
            return liman.LIMERR_NOT_SUPPORTED;
        }

        /* INSERT the code to perform the sort */
		Console.WriteLine("Heap_Sort is allowed with existing license");

        return 0;

    }

    public static int Insertion_Sort(SWIGTYPE_p_LIMLIC pLic, int[] array)

    {

        if (0 == liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_3))
        {
			// feature is not available
			Console.WriteLine("Insertion_Sort is not allowed with existing license");
            return liman.LIMERR_NOT_SUPPORTED;

        }

        /* INSERT the code to perform the sort */
		Console.WriteLine("Insertion_Sort is allowed with existing license");

        return 0;

    }

    public static int Intro_Sort(SWIGTYPE_p_LIMLIC pLic, int[] array)

    {

        if (0 == liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_4))
        {
			// feature is not available
			Console.WriteLine("Intro_Sort is not allowed with existing license");
            return liman.LIMERR_NOT_SUPPORTED;

        }

        /* INSERT the code to perform the sort */
		Console.WriteLine("Intro_Sort is allowed with existing license");

        return 0;

    }

    public static int Block_Sort(SWIGTYPE_p_LIMLIC pLic, int[] array)

    {

        if (0 == liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_5))
        {
			// feature is not available
			Console.WriteLine("Block_Sort is not allowed with existing license");
            return liman.LIMERR_NOT_SUPPORTED;

        }

        /* INSERT the code to perform the sort */
		Console.WriteLine("Block_Sort is allowed with existing license");

        return 0;

    }

    public static int Shell_Sort(SWIGTYPE_p_LIMLIC pLic, int[] array)

    {

        if (0 == liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_6))
        {
			// feature is not available
			Console.WriteLine("Shell_Sort is not allowed with existing license");
            return liman.LIMERR_NOT_SUPPORTED;       
        }

        /* INSERT the code to perform the sort */
		Console.WriteLine("Shell_Sort is allowed with existing license");

        return 0;

    }

    public static int Bubble_Sort(SWIGTYPE_p_LIMLIC pLic, int[] array)

    {

        if (0 == liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_7))
        {
			// feature is not available
			Console.WriteLine("Bubble_Sort is not allowed with existing license");
            return liman.LIMERR_NOT_SUPPORTED;         

        }

        /* INSERT the code to perform the sort */
		Console.WriteLine("Bubble_Sort is allowed with existing license");

        return 0;

    }

    //! [Sort Functions]

    /*

     *  Run application function 0

     *  which requires the license to have features 1 and 2

     **/

    public static int app_function0(SWIGTYPE_p_LIMLIC pLic)
    {

        // this function requires feature[1] 1st and 2nd bits turned on
        if (0 == liman.lim_has_feature(pLic, 1, liman.LIMOPT_FEATURE_0) || 0 == liman.lim_has_feature(pLic, 1, liman.LIMOPT_FEATURE_1))
        {
            //license does not support
            Console.WriteLine("app_function0 is not allowed with existing license");
            return liman.LIMERR_NOT_SUPPORTED;
        }

        //proceed with feature

        Console.WriteLine("app_function0 is allowed with existing license");

        /* INSERT FUNCTION-2 CODE */

        return 0;

    }

    /*

     *  Run application function 1

     *  which requires the license to have features 1

     **/

    public static int app_function1(SWIGTYPE_p_LIMLIC pLic)
    {

        // this function requires feature[1] 1st bit turned on
        if (0 == liman.lim_has_feature(pLic, 1, liman.LIMOPT_FEATURE_0))
        {
            //license does not support
            Console.WriteLine("app_function1 is not allowed with existing license");
            return liman.LIMERR_NOT_SUPPORTED;
        }

        //proceed with feature

        Console.WriteLine("app_function1 is allowed with existing license");

        /* INSERT FUNCTION-1 CODE */

        return 0;

    }

    /*

     *  Run application function 2

     *  which requires the license to have features 1 and 16

     **/

    public static int app_function2(SWIGTYPE_p_LIMLIC pLic)
    {

        // this function requires feature[1] 1st and 5th bits turned on
        if (0 == liman.lim_has_feature(pLic, 1, liman.LIMOPT_FEATURE_0) || 0 == liman.lim_has_feature(pLic, 1, liman.LIMOPT_FEATURE_4))
        {
            //license does not support
            Console.WriteLine("app_function2 is not allowed with existing license");
            return liman.LIMERR_NOT_SUPPORTED;
        }

        //proceed with feature

        Console.WriteLine("app_function2 is allowed with existing license");

        /* INSERT FUNCTION-2 CODE */

        return 0;

    }

    public static void Main(string[] args)
    {
        if (args.Length < 2)
        {

            Console.WriteLine("\nUsage: testapp [product_id] [license_file]\n");

            return;

        }

        StringBuilder sBuffer = new StringBuilder("", 1024);
        liman.lim_get_verstr(sBuffer);
        Console.WriteLine();
        Console.WriteLine("Version: " + sBuffer.ToString());
		
        szProduct = args[0];

        szLicFile = args[1];

        testapp_run();

    }

    public static void onError(SWIGTYPE_p_LIMENV pEnv, int[] pnErr)

    {

        StringBuilder sbuf = new StringBuilder(255);

        if (pnErr[0] != liman.LIM_OK)

        {

            sbuf.Length = 0;

            liman.lim_get_errmsg(pEnv, pnErr[0], sbuf);

            Console.WriteLine("Error " + pnErr[0] + ": " + sbuf.ToString());

        }

    }

    /*

     * Entry point

     */

    public static int testapp_run()

    {

        SWIGTYPE_p_LIMENV pEnv;

        SWIGTYPE_p_LIMLIC pLic;

        int[] pnErr = new int[1];

        int[] keyLen = new int[1];

        pnErr[0] = liman.LIM_OK;
        
        Console.Write("Application is using license file '{0}'\n", szLicFile);

        /* get license */

        pEnv = liman.lim_create_env(2048, 256, out pnErr[0]);

        if (pnErr[0] != liman.LIM_OK)
        {

            onError(pEnv, pnErr);

        }

        if (2 > 1)
        {
			// Public key is hardwired into the app (recommended)
            String szPubKey = "F4FFF999C2D782A1B73BDDF48187A70B6C2418C20B02A8BD862A490DE798D7C20556976550C47C45D9650E312308CED84CAC22691B4AD0C77775524D98E81D46578C9228F2CCB3C8F78AFBDA68D598031DA7FEBC46DF4D8CA43F3A4DAF0BC65AB14D87BC113291BB6F786D35A713EFF2B4014DFD6CAFFE9BBEBEA328CEC71BE15230AC41845B52A332CC1248B63C26F38B6CEE6C28904EA845A85A61F7EBA29E71C1499DBD2B272A5A5334BD29D97AB91490C8A3D2BC4B35738DF8AB1840DEB8106422968995735379AD46DB9EBD4E421114FD272075696831BB87E2822159AD0633A8F4299B9EAE92F381784F409C46E08C5C5856AA17D831825C25C70A98E3";

			Console.Write("Loading public key..");
            pnErr[0] = liman.lim_load_public_key(pEnv, szPubKey);

            if (pnErr[0] != liman.LIM_OK) { onError(pEnv, pnErr); }

            Console.WriteLine("ok.");

        }

        else
        {
			
			// Public key lives outside the app and is read from an external file (not recommended)
			String szPublicKeyFile = "../keys/" + szProduct + "/" + szProduct + "_public.key";            
			
			Console.Write("Reading public key..");
            pnErr[0] = liman.lim_read_public_key(pEnv, szPublicKeyFile);

            if (pnErr[0] != liman.LIM_OK) { onError(pEnv, pnErr); }

            Console.WriteLine("ok.");

        }

        if (pnErr[0] != liman.LIM_OK) { onError(pEnv, pnErr); }



        pLic = liman.lim_create_lic_fromfile(pEnv, szLicFile, out pnErr[0]);

        if (pnErr[0] != liman.LIM_OK)
        {

            onError(pEnv, pnErr);

        }

        Console.Write("Application License id: '{0}'\n", liman.lim_lic_id(pLic));

        pnErr[0] = liman.lim_is_verified(pLic);

        if (pnErr[0] != liman.LIM_OK)
        {

            onError(pEnv, pnErr);

        }

        if (pnErr[0] != liman.LIM_OK)
        {

            Console.WriteLine("Warning: License is not verified");

            onError(pEnv, pnErr);

        }

        else
        {

            Console.WriteLine("Application License is verified!");

        }

        //String product_id = new String(szProduct);

        if (szProduct.Equals(liman.lim_product_id(pLic)) == false)
        {

            pnErr[0] = liman.LIMERR_INVALID_PRODUCT_CODE;

            onError(pEnv, pnErr);

        }

        if (liman.lim_size_id(pLic) == liman.LIMSIZE_DEMO)
        {

            Console.WriteLine("Application is using demo license.");

            onError(pEnv, pnErr);

        }

        Console.Write("Application License version is {0}.{1}.\n", liman.lim_major_version(pLic), liman.lim_minor_version(pLic));

        // display license size and impose limitations accordingly

        if (liman.lim_platform_id(pLic) != liman.LIMPLAT_WIN32X86)
        {

            pnErr[0] = liman.LIMERR_INVALID_PLATFORM;

            onError(pEnv, pnErr);

        }

        else

        {

            Console.Write("Application License is valid for platform-id {0}.\n", liman.lim_platform_id(pLic));

        }

        // display license size and impose limitations accordingly

        Console.Write("Application License type is {0}.\n", liman.lim_type_id(pLic));

        if (liman.lim_type_id(pLic) == liman.LIMTYPE_EDUCATIONAL)
        {

            // INSERT CODE

        }

        // display license size and impose limitations accordingly

        Console.Write("Application License size is {0}.\n", liman.lim_size_id(pLic));

        if (liman.lim_size_id(pLic) == liman.LIMSIZE_DEMO)
        {

            // INSERT CODE

        }

        // 0'th slot specifies which sorting methods are available under given license key



        {

            //! [Availability of Sort Functions]

            // Check bitmasks in feature-slot 0
            if (1 == liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_0))
            {

                Console.Write("Quick Sort Feature is available\n");

            }

            if (1 == liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_1))
            {

                Console.Write("Merge Sort Feature is available\n");

            }

            if (1 == liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_2))
            {

                Console.Write("Heap Sort Feature is available\n");

            }

            if (1 == liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_3))
            {

                Console.Write("Insertion Sort Feature is available\n");

            }

            if (1 == liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_4))
            {

                Console.Write("Intro Sort Feature is available\n");

            }

            if (1 == liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_5))
            {

                Console.Write("Block Sort Feature is available\n");

            }

            if (1 == liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_6))
            {

                Console.Write("Shell Sort Feature is available\n");

            }

            if (1 == liman.lim_has_feature(pLic, 0, liman.LIMOPT_FEATURE_7))
            {

                Console.Write("Bubble Sort Feature is available\n");

            }
            //! [Availability of Sort Functions]
        }

        // 1'st slot specifies which functions are avaiable under given license key
        {
            // run function 0
            pnErr[0] = app_function0(pLic);
			if (pnErr[0] != liman.LIM_OK)
			{
				onError(pEnv, pnErr);
			}            

            // run function 1
            pnErr[0] = app_function1(pLic);
			if (pnErr[0] != liman.LIM_OK)
			{
				onError(pEnv, pnErr);
			}            
            

            // run function 2
            pnErr[0] = app_function2(pLic);
			if (pnErr[0] != liman.LIM_OK)
			{
				onError(pEnv, pnErr);
			}            
            
        }


        liman.lim_delete_lic(pLic);

        liman.lim_delete_env(pEnv);

        return 0;

    }
}
