#
# Detect platform (included from makefiles)
# 
# Baroks Inc.

UNAME_S := $(shell uname -s)
UNAME_O := $(shell uname -o)
UNAME_M := $(shell uname -m)
EXT :=
ifeq ($(UNAME_S),Linux)
	PLATFORM := linux
else ifeq ($(UNAME_S),Darwin)
	PLATFORM := osx
else ifeq ($(UNAME_O),Cygwin)
	PLATFORM := cyg
	EXT := .exe
endif

ifeq ($(UNAME_M),x86_64)
	PLATFORM := ${PLATFORM}64x86
else ifneq ($(filter %86,$(UNAME_M)),)
	PLATFORM := ${PLATFORM}32x86
endif

ifneq ($(filter arm%,$(UNAME_M)),)
	PLATFORM := $(UNAME_M)
endif
