# LIMAN SDK Libraries

Platform-specific libraries and binaries for the LIMAN SDK license management system.

## Directory Structure

```
lib/
├── linux64x86/    # Linux 64-bit x86_64
├── osx64x86/      # macOS 64-bit x86_64
├── win32x86/      # Windows 32-bit x86
└── win64x86/      # Windows 64-bit x86_64
```

## Quick Start

### Windows

```batch
nmake
limutil --genkey --keysize=2048 --product=MYPRODUCT
nmake product PRODUCT=MYPRODUCT
```

### Linux/macOS

```bash
make
./limutil --genkey --keysize=2048 --product=MYPRODUCT
make product PRODUCT=MYPRODUCT
```

## Build Output

After building, each platform directory contains:

| File | Description |
|------|-------------|
| `limgen` | License generation utility |
| `limutil` | Key generation and system info utility |
| `libliman_sdk.a` | Static library for linking |
| `libliman_sdk.so` | Shared library (Linux) |

## Product Directories

Each product (e.g., `MYPRODUCT/`) contains:

| File | Description |
|------|-------------|
| `MYPRODUCT_private.key` | Private key (keep secure) |
| `MYPRODUCT_public.key` | Public key (embed in application) |
| `MYPRODUCT_config.json` | Feature definitions |
| `usr_*.lic` | Generated license files |

## Cleanup

```bash
make product PRODUCT=MYPRODUCT clean
make clean
```

## License

LIMAN SDK requires a valid license. Contact sales@baroks.com or visit https://baroks.com
