@echo off&setlocal
rem cmd
rem Generate a new license for TESTAPP product using its designated key-pair
rem (c) Baroks Inc.
rem $Id$
rem
set LIMAN_ROOT=..\..

rem get PLATFORM from directory
for %%a in (.) do set PLATFORM=%%~na
@echo Platform: %PLATFORM%

set PRODUCT=TESTAPP
if "%PRODUCT%" == "" goto usage
set LIMGEN=%LIMAN_ROOT%\lib\%PLATFORM%\limgen

rem Location of public key (modify if needed)
set PUB=%LIMAN_ROOT%\lib\%PLATFORM%\%PRODUCT%\%PRODUCT%_public.key

rem Location of private key (modify if needed)
set PRIV=%LIMAN_ROOT%\lib\%PLATFORM%\%PRODUCT%\%PRODUCT%_private.key

rem Generate a product key with specified input
rem Type limgen -h for help
@echo Product: %PRODUCT%
@echo Private key file: %PUB%
@echo Public key file: %PRIV%
%LIMGEN% --product=%PRODUCT% --major=1 --minor=0 -T --privkeyfile=%PRIV%  --pubkeyfile=%PUB% %1 %2 %3 %4 %5
@echo.
@echo The command that generated the license file was:
@echo %LIMGEN% --product=%PRODUCT% --major=1 --minor=0 -T --privkeyfile=%PRIV%  --pubkeyfile=%PUB% %1 %2 %3 %4 %5
goto end

:usage
@echo Usage: lg_testapp [limgen-options]
goto end
:noplatform
@echo Variable 'PLATFORM' not set. Type 'set PLATFORM=<platform>' and re-run
goto end
:end