
import com.baroks.liman.*;

public class ex1
{
	private static String OS = System.getProperty("os.name").toLowerCase();

    static
    {
        /// @brief Load LIMAN SDK dynamic libarary
        try {
			if (OS.contains("win")) {
            	System.loadLibrary("libliman_sdk");
			} else {
				System.loadLibrary("liman_sdk"); //prefix <lib> is implied on non-windows
			}
        }
        catch (Exception e)
        {
            String limanRoot = System.getenv("LIMAN_ROOT");

            if (limanRoot == null) {
                System.out.println("Error: LIMAN_ROOT environment variable is not defined.. ");
            } else {
				try {
					System.load(limanRoot + "/lib/linux64x86/libliman_sdk.so");
				}

				catch (Exception e2) {
					System.load(limanRoot + "/lib/osx64x86/libliman_sdk.jnilib");
				}
		    }
        }
    }

    /****************************************************/
    private static int main_sub2()
    {
		 int pnErr[]    = new int[1];
		 StringBuffer szP = new StringBuffer(1024);
		 StringBuffer szQ = new StringBuffer(1024);
		 StringBuffer szN = new StringBuffer(1024);

         ex1 ls = new ex1();
         /* data */
         SWIGTYPE_p_LIMENV pEnv = liman.lim_create_env(2048,256,pnErr);

		 System.out.print("Reading public key..");
         pnErr[0] = liman.lim_read_public_key(pEnv, "../keys/TESTAPP/TESTAPP_public.key");
         if (pnErr[0]!=0) {
			 System.out.printf("\nError %d: %s\n",pnErr[0],liman.lim_errmsg(pEnv,pnErr[0]));
			 return 1;
		 }		 ;
		 System.out.println("ok");
		 System.out.print("Read private key..");
         pnErr[0] = liman.lim_read_private_key(pEnv, "../keys/TESTAPP/TESTAPP_private.key");
         if (pnErr[0]!=0) {
			 System.out.printf("\nError %d: %s\n",pnErr[0],liman.lim_errmsg(pEnv,pnErr[0]));
			 return 1;
		 }
		 System.out.println("ok");
		 pnErr[0] = liman.lim_get_keypair(pEnv, szP, szQ, szN);
	     System.out.println("P:" + szP);
	     System.out.println("Q:" + szQ);
	     System.out.println("N:" + szN);
         int  lisansLen, nout=0,outbytes[]= new int[1];
         int  outlen[] = new int[1];
         StringBuffer encbuf = new StringBuffer(2048);
         byte decbuf[] = new byte[4096];
         StringBuffer foobuf = new StringBuffer(2048);
         StringBuffer options = new StringBuffer("     ");
         int a[] = new int[1];
         int b[] = new int[1];
         int c[] = new int[1];
         int d[] = new int[1];

         options.setCharAt(0,(char)15);
         options.setCharAt(1,(char)1);
         options.setCharAt(2,(char)22);
         options.setCharAt(3,(char)31);
         options.setCharAt(4,(char)1);


	     foobuf.setLength(0);
         pnErr[0] = liman.lim_get_verstr(foobuf);
         System.out.printf("LIMAN %s\n",foobuf.toString());

         foobuf.setLength(0);
         pnErr[0] = liman.lim_get_hostid(foobuf,9);
         System.out.printf("HOSTID: %s\n",foobuf.toString());

        // create a license to test
         System.out.println();
         System.out.println("---------------------------------");
         System.out.println(" Setting up encryption engine   :");
         System.out.println("---------------------------------");

	     SWIGTYPE_p_LIMLIC pLisans[] = new SWIGTYPE_p_LIMLIC[1];
         pLisans[0] = liman.lim_create_lic(pEnv,pnErr);
         if (pnErr[0]!=0) {
			 System.out.printf("Error %d: %s\n",pnErr[0],liman.lim_errmsg(pEnv,pnErr[0]));
		 }
		 System.out.println("Create a blank license instance");

         String szProductCode="TESTAPP";
         int mPlatformId=liman.LIMPLAT_WIN32X86;
         int nMajorVersion=1;
         int nMinorVersion=0;
         int mSizeId=liman.LIMSIZE_STANDARD;
         int mTypeId=liman.LIMTYPE_EDUCATIONAL;
         int nUsers=1;
         int nExpiration=liman.LIMPAR_NONE;
         String pcFeatures=options.toString();
         String szSerial="SN123456";
         liman.lim_gen_uuid(pEnv,1031,encbuf);
         String szUUID=encbuf.toString();

         StringBuffer szHostId = new StringBuffer(255);
         pnErr[0] = liman.lim_get_hostid(szHostId,9);
         String szUserId="mka";
         int nHostIdMask=9;
        // load license fields
         pnErr[0] =  liman.lim_load_lic(pLisans[0],
         			   szProductCode,
                       mPlatformId,
                       nMajorVersion,
                       nMinorVersion,
                       mSizeId,
                       mTypeId,
                       nUsers,
                       nExpiration,
                       pcFeatures,
                       szSerial,
                       szUUID,
                       szHostId.toString(),
                       szUserId,
                       nHostIdMask);
         if (pnErr[0]!=0) {
			 System.out.printf("Error %d: %s\n",pnErr[0],liman.lim_errmsg(pEnv,pnErr[0]));
		 }
		 System.out.printf("Loaded license specs for HOSTID: %s",szHostId.toString());
		 System.out.println(" (UUID: " + liman.lim_canonical_uuid(szUUID) + ")");
		 System.out.println(pLisans);


		 pnErr[0] = liman.lim_copy_lic2str(pLisans[0],encbuf);
		 System.out.println(encbuf.toString());

        // get license key
         String szlicKey = liman.lim_get_lickey(pLisans[0]);
         System.out.println();
         System.out.println("-----------------------");
         System.out.println(" Encrypted license    :");
         System.out.println("-----------------------");
         // display encrypted license
         System.out.println("License key: " + szlicKey);

		 pnErr[0] = liman.lim_print_lic(pLisans[0],encbuf);
		 System.out.println(encbuf.toString());

         // destroy license
         pnErr[0] = liman.lim_delete_lic(pLisans[0]);
         System.out.println("ptr:" + pLisans[0]);

         return 0;
    }

    public static void main(String[] argv)
    {
	main_sub2();
    }

}
