#!/bin/sh
LIMAN_ROOT=$(pwd)
echo
echo LIMAN_ROOT=$LIMAN_ROOT
export LIMAN_ROOT
UNAME=`uname`
PLATFORM=$1
echo ${UNAME}
if [ "${PLATFORM}" != "" ]; then
	echo PLATFORM arg was specified: $PLATFORM
elif [ "${UNAME:0:6}" = "CYGWIN" ]; then
	PLATFORM=win64x86
elif [ "${UNAME:0:7}" = "MINGW64" ]; then
	PLATFORM=win64x86	
elif [ "${UNAME:0:7}" = "MINGW32" ]; then
	PLATFORM=win32x86		
elif [ "${UNAME}" = "Linux" ]; then
	PLATFORM=linux64x86
elif [ "${UNAME}" = "Darwin" ]; then
	PLATFORM=osx64x86
fi
echo
export PATH=$PATH:$LIMAN_ROOT/bin/$PLATFORM:$LIMAN_ROOT/lib/$PLATFORM

