#!/bin/sh
# Generate a new license for the specified product using its designated key-pair
# (c) Baroks Inc.
# $Id$
#
LIMAN_ROOT=../..
PWD=`pwd`
PLATFORM=${PWD##*/}
echo Platform: $PLATFORM

if [ "$1" = "" -o "$2" = "" ]; then
	echo
	echo Usage: lic_info.sh \"path/to/license/file.lic\" PRODUCT_CODE
	exit 1
fi

PRODUCT=$2

LIMGEN=$LIMAN_ROOT/lib/${PLATFORM}/limgen

#Location of public key (modify if needed)
PUB=$LIMAN_ROOT/lib/${PLATFORM}/${PRODUCT}/${PRODUCT}_public.key

#Location of private key (modify if needed)
PRIV=$LIMAN_ROOT/lib/${PLATFORM}/${PRODUCT}/${PRODUCT}_private.key

#Generate a product key with specified input
#Type limgen -h for help
echo Product: $PRODUCT
echo Private key file: $PRIV
echo Public key file: $PUB
$LIMGEN --privkeyfile=$PRIV  --pubkeyfile=$PUB -L $1
